/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.command.diff;

import com.atlassian.bitbucket.content.ChangeType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public enum GitChangeType {
    ADD(ChangeType.ADD, "A"),
    COPY(ChangeType.COPY, "C", true),
    DELETE(ChangeType.DELETE, "D"),
    MODIFY(ChangeType.MODIFY, "M"),
    RENAME(ChangeType.MOVE, "R", true),
    TYPE(ChangeType.UNKNOWN, "T"),
    UNMERGED(ChangeType.UNKNOWN, "U"),
    UNKNOWN(ChangeType.UNKNOWN, "X");

    private final boolean scored;
    private final String status;
    private final ChangeType type;

    private GitChangeType(ChangeType type, String status) {
        this(type, status, false);
    }

    private GitChangeType(ChangeType type, String status, boolean scored) {
        this.scored = scored;
        this.status = status;
        this.type = type;
    }

    @Nonnull
    public static GitChangeType fromStatus(@Nullable String status) {
        for (GitChangeType value : GitChangeType.values()) {
            if (!StringUtils.equals((CharSequence)status, (CharSequence)value.getStatus())) continue;
            return value;
        }
        return UNKNOWN;
    }

    @Nonnull
    public String getStatus() {
        return this.status;
    }

    @Nonnull
    public ChangeType getType() {
        return this.type;
    }

    public boolean isScored() {
        return this.scored;
    }
}

