/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.command.revlist;

import com.atlassian.bitbucket.commit.CommitListMergeFilter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum GitRevListMerges {
    DEFAULT,
    EXCLUDE("--no-merges"),
    INCLUDE("--no-min-parents"),
    ONLY("--merges");

    private final String flag;

    private GitRevListMerges() {
        this.flag = null;
    }

    private GitRevListMerges(String flag) {
        this.flag = flag;
    }

    @Nullable
    public String getFlag() {
        return this.flag;
    }

    public boolean isFlagged() {
        return this.flag != null;
    }

    @Nonnull
    public static GitRevListMerges fromFilter(@Nonnull CommitListMergeFilter value) {
        if (value == CommitListMergeFilter.EXCLUDE) {
            return EXCLUDE;
        }
        if (value == CommitListMergeFilter.INCLUDE) {
            return INCLUDE;
        }
        if (value == CommitListMergeFilter.ONLY) {
            return ONLY;
        }
        throw new IllegalArgumentException("Value not a valid commit list merge filter value: " + String.valueOf(value));
    }
}

