/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.command.revlist;

import com.atlassian.bitbucket.commit.CommitOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum GitRevListOrder {
    DATE("--date-order"),
    DEFAULT,
    TOPOLOGICAL("--topo-order");

    private final String flag;

    private GitRevListOrder() {
        this.flag = null;
    }

    private GitRevListOrder(String flag) {
        this.flag = flag;
    }

    @Nullable
    public String getFlag() {
        return this.flag;
    }

    public boolean isFlagged() {
        return this.flag != null;
    }

    @Nonnull
    public static GitRevListOrder fromCommitOrder(@Nonnull CommitOrder order) {
        if (order == CommitOrder.TOPOLOGICAL) {
            return TOPOLOGICAL;
        }
        if (order == CommitOrder.DATE || order == CommitOrder.DEFAULT) {
            return DEFAULT;
        }
        throw new IllegalArgumentException("Unknown CommitOrder: " + order.name());
    }
}

