/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.ref;

import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;

public class GitResolveAnnotatedTagsCommandParameters
extends AbstractCommandParameters {
    public static final int UNLIMITED_MESSAGE_LENGTH = -1;
    private final int maxMessageLength;
    private final Set<String> tagIds;

    private GitResolveAnnotatedTagsCommandParameters(Builder builder) {
        this.maxMessageLength = builder.maxMessageLength;
        this.tagIds = builder.tagIds.build();
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    @Nonnull
    public Set<String> getTagIds() {
        return this.tagIds;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> tagIds = ImmutableSet.builder();
        private int maxMessageLength = -1;

        @Nonnull
        public GitResolveAnnotatedTagsCommandParameters build() {
            return new GitResolveAnnotatedTagsCommandParameters(this);
        }

        @Nonnull
        public Builder tagIds(@Nullable String value, String ... moreValues) {
            Builder.addIf(Objects::nonNull, this.tagIds, (Object)value, (Object[])moreValues);
            return this;
        }

        @Nonnull
        public Builder tagIds(@Nullable Iterable<String> values) {
            Builder.addIf(Objects::nonNull, this.tagIds, values);
            return this;
        }

        @Nonnull
        public Builder maxMessageLength(int value) {
            this.maxMessageLength = value;
            return this;
        }
    }
}

