/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.worktree;

import com.atlassian.bitbucket.scm.git.worktree.GitWorkTreeRepositoryHookInvoker;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Objects;

public class PublishGitWorkTreeParameters {
    private final Person author;
    private final String branch;
    private final String expectedHash;
    private final GitWorkTreeRepositoryHookInvoker hookInvoker;
    private final Duration timeout;

    private PublishGitWorkTreeParameters(Builder builder) {
        this.author = builder.author;
        this.branch = builder.branch;
        this.expectedHash = builder.expectedHash;
        this.hookInvoker = builder.hookInvoker;
        this.timeout = builder.timeout;
    }

    @Nullable
    public Person getAuthor() {
        return this.author;
    }

    @Nonnull
    public String getBranch() {
        return this.branch;
    }

    @Nullable
    public String getExpectedHash() {
        return this.expectedHash;
    }

    @Nonnull
    public GitWorkTreeRepositoryHookInvoker getHookInvoker() {
        return this.hookInvoker;
    }

    @Nullable
    public Duration getTimeout() {
        return this.timeout;
    }

    public static class Builder
    extends BuilderSupport {
        private final GitWorkTreeRepositoryHookInvoker hookInvoker;
        private Person author;
        private String branch;
        private String expectedHash;
        private Duration timeout;

        public Builder(@Nonnull GitWorkTreeRepositoryHookInvoker hookInvoker) {
            this.hookInvoker = Objects.requireNonNull(hookInvoker, "hookInvoker");
        }

        @Nonnull
        public Builder author(@Nonnull Person value) {
            this.author = Objects.requireNonNull(value, "author");
            return this;
        }

        @Nonnull
        public Builder branch(@Nonnull String branch, @Nullable String expectedHash) {
            this.branch = Builder.checkNotBlank((String)branch, (String)"branch");
            this.expectedHash = expectedHash;
            return this;
        }

        @Nonnull
        public PublishGitWorkTreeParameters build() {
            Builder.checkNotBlank((String)this.branch, (String)"required branch is not set");
            return new PublishGitWorkTreeParameters(this);
        }

        @Nonnull
        public Builder timeout(@Nonnull Duration value) {
            this.timeout = Objects.requireNonNull(value, "timeout");
            return this;
        }
    }
}

