/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.build;

import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusSetRequest;
import com.atlassian.bitbucket.dmz.rest.v2.build.RestTestResults;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;

@JsonSerialize
public class RestBuildStatusSetRequest
extends RestMapEntity {
    private static final String BUILD_NUMBER = "buildNumber";
    private static final int BUILD_NUMBER_MAX_LEN = 255;
    private static final String DESCRIPTION = "description";
    private static final int DESCRIPTION_MAX_LEN = 255;
    private static final String DURATION = "duration";
    private static final String KEY = "key";
    private static final int KEY_MAX_LEN = 255;
    private static final String LAST_UPDATED = "lastUpdated";
    private static final String NAME = "name";
    private static final int NAME_MAX_LEN = 255;
    private static final String PARENT = "parent";
    private static final int PARENT_MAX_LEN = 1024;
    private static final String REF = "ref";
    private static final int REF_MAX_LEN = 1024;
    private static final String STATE = "state";
    private static final String TEST_RESULTS = "testResults";
    private static final String URL = "url";
    private static final int URL_MAX_LEN = 450;

    public RestBuildStatusSetRequest() {
    }

    public RestBuildStatusSetRequest(RepositoryBuildStatusSetRequest request) {
        this.put(KEY, request.getKey());
        this.put(STATE, request.getState());
        this.put(URL, request.getUrl());
        this.putIfNotNull(BUILD_NUMBER, request.getBuildNumber());
        this.putIfNotNull(DESCRIPTION, request.getDescription());
        this.putIfNotNull(DURATION, request.getDuration());
        this.put(LAST_UPDATED, request.getLastUpdated());
        this.putIfNotNull(NAME, request.getName());
        this.putIfNotNull(PARENT, request.getParent());
        this.putIfNotNull(REF, request.getRef());
        if (request.getTestResults() != null) {
            this.put(TEST_RESULTS, new RestTestResults(request.getTestResults()));
        }
    }

    @Schema(example="3")
    @Size(message="{bitbucket.rest.repository.build.status.buildNumber.oversized}", max=255)
    public @Size(message="{bitbucket.rest.repository.build.status.buildNumber.oversized}", max=255) String getBuildNumber() {
        return this.getStringProperty(BUILD_NUMBER);
    }

    @Schema(example="Unit test build")
    public String getDescription() {
        return StringUtils.abbreviate((String)this.getStringProperty(DESCRIPTION), (int)255);
    }

    @Schema(example="1500000")
    public Long getDuration() {
        long duration = this.getLongProperty(DURATION);
        if (duration < 0L) {
            return null;
        }
        return duration;
    }

    @Schema(example="TEST-REP123")
    @NotBlank(message="{bitbucket.rest.repository.build.status.key.invalid}")
    @Size(message="{bitbucket.rest.repository.build.status.key.invalid}", max=255)
    public @NotBlank(message="{bitbucket.rest.repository.build.status.key.invalid}") @Size(message="{bitbucket.rest.repository.build.status.key.invalid}", max=255) String getKey() {
        return this.getStringProperty(KEY);
    }

    @Schema(example="1359075920")
    @Nullable
    public Long getLastUpdated() {
        try {
            return this.getLong(LAST_UPDATED);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    @Schema(example="Database Matrix Tests")
    @Size(message="{bitbucket.rest.repository.build.status.name.oversized}", max=255)
    public @Size(message="{bitbucket.rest.repository.build.status.name.oversized}", max=255) String getName() {
        return this.getStringProperty(NAME);
    }

    @Schema(example="TEST-REP")
    @Size(message="{bitbucket.rest.repository.build.status.parent.oversized}", max=1024)
    public @Size(message="{bitbucket.rest.repository.build.status.parent.oversized}", max=1024) String getParent() {
        return this.getStringProperty(PARENT);
    }

    @Schema(example="refs/heads/master")
    @Size(message="{bitbucket.rest.repository.build.status.ref.oversized}", max=1024)
    @Pattern(regexp="^refs\\/.*", message="{bitbucket.rest.repository.build.status.ref.pattern}")
    public @Size(message="{bitbucket.rest.repository.build.status.ref.oversized}", max=1024) @Pattern(regexp="^refs\\/.*", message="{bitbucket.rest.repository.build.status.ref.pattern}") String getRef() {
        return this.getStringProperty(REF);
    }

    @NotNull(message="{bitbucket.rest.repository.build.status.state.error}")
    public @NotNull(message="{bitbucket.rest.repository.build.status.state.error}") BuildState getState() {
        return this.getEnumProperty(STATE, BuildState.class, null);
    }

    public RestTestResults getTestResults() {
        return RestTestResults.valueOf(this.get(TEST_RESULTS));
    }

    @Schema(example="https://bamboo.example.com/browse/TEST-REP1-3")
    @NotBlank(message="{bitbucket.rest.repository.build.status.url.required}")
    @Size(message="{bitbucket.rest.repository.build.status.url.oversized}", max=450)
    public @NotBlank(message="{bitbucket.rest.repository.build.status.url.required}") @Size(message="{bitbucket.rest.repository.build.status.url.oversized}", max=450) String getUrl() {
        return this.getStringProperty(URL);
    }

    private Long getLong(String property) throws NumberFormatException {
        Object value = this.get(property);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        return null;
    }
}

