/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.cluster;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.function.Function;

@JsonSerialize
@JsonSurrogate(value=ClusterNode.class)
public class RestClusterNode
extends RestMapEntity {
    public static final Function<ClusterNode, RestClusterNode> REST_TRANSFORM = RestClusterNode::new;
    private static final String ADDRESS = "address";
    private static final String BUILD_VERSION = "buildVersion";
    private static final String HOST_NAME = "hostName";
    private static final String ID = "id";
    private static final String LOCAL = "local";
    private static final String NAME = "name";
    private static final String PORT = "port";

    public RestClusterNode(ClusterNode node) {
        InetSocketAddress socketAddress = node.getAddress();
        this.put(ID, node.getId());
        this.put(BUILD_VERSION, node.getBuildVersion().toString());
        this.put(NAME, node.getName());
        this.put(ADDRESS, ImmutableMap.of((Object)HOST_NAME, (Object)socketAddress.getHostString(), (Object)PORT, (Object)socketAddress.getPort()));
        this.put(LOCAL, node.isLocal());
    }

    @Schema(implementation=ExampleSocketAddress.class)
    @Nonnull
    public Map<String, Object> getAddress() {
        return (Map)this.get(ADDRESS);
    }

    @Schema(example="7.0.0")
    @Nonnull
    public String getBuildVersion() {
        return this.getStringProperty(BUILD_VERSION);
    }

    @Schema(example="d4fde8b1-2504-4998-a0ba-14fbe98edd4d")
    @Nonnull
    public String getId() {
        return this.getStringProperty(ID);
    }

    @Schema(example="foo")
    @Nonnull
    public String getName() {
        return this.getStringProperty(NAME);
    }

    @Nonnull
    public boolean isLocal() {
        return this.getBoolProperty(LOCAL);
    }

    private static class ExampleSocketAddress {
        private ExampleSocketAddress() {
        }

        @Schema(example="node.example.com")
        public String getAddress() {
            throw new RuntimeException("This method should not be invoked");
        }

        @Schema(example="8230")
        public Integer getPort() {
            throw new RuntimeException("This method should not be invoked");
        }
    }
}

