/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.content;

import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.Directory;
import com.atlassian.bitbucket.dmz.rest.v2.content.RestContentTreeNode;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.content.RestPath;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;

@JsonSerialize
@JsonSurrogate(value=Directory.class)
public class RestDirectory
extends RestMapEntity
implements RestContentTreeNode {
    private static final String NODE = "node";
    private static final String PATH = "path";
    private static final String TYPE = "type";

    public RestDirectory(Directory directory) {
        this(RestPath.fromPath(directory.getPath()), directory.getContentId());
    }

    public RestDirectory(RestPath path, String node) {
        this.put(PATH, path);
        this.put(NODE, node);
        this.put(TYPE, ContentTreeNode.Type.DIRECTORY);
    }

    @Schema(example="f653d2de741745fbd9826ce0f65b57f471d7583e")
    public String getNode() {
        return this.getStringProperty(NODE);
    }

    public RestPath getPath() {
        return (RestPath)this.get(PATH);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY, example="DIRECTORY")
    public ContentTreeNode.Type getType() {
        return this.getEnumProperty(TYPE, ContentTreeNode.Type.class);
    }
}

