/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.content;

import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.Submodule;
import com.atlassian.bitbucket.dmz.rest.v2.content.RestContentTreeNode;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.content.RestPath;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;

@JsonSerialize
@JsonSurrogate(value=Submodule.class)
public class RestSubmodule
extends RestMapEntity
implements RestContentTreeNode {
    private static final String BROWSE_URL = "browseUrl";
    private static final String CONTENT_ID = "contentId";
    private static final String PATH = "path";
    private static final String REPOSITORY_URL = "repositoryUrl";
    private static final String TYPE = "type";
    private static final String URL = "url";

    public RestSubmodule(Submodule submodule) {
        this(RestPath.fromPath(submodule.getPath()), submodule.getContentId(), submodule.getUrl(), submodule.getRepositoryUrl(), submodule.getBrowseUrl());
    }

    private RestSubmodule(RestPath path, String contentId, String url, String repositoryUrl, String browseUrl) {
        this.put(PATH, path);
        this.put(CONTENT_ID, contentId);
        this.put(TYPE, ContentTreeNode.Type.SUBMODULE);
        this.put(URL, url);
        this.putIfNotNull(REPOSITORY_URL, repositoryUrl);
        this.putIfNotNull(BROWSE_URL, browseUrl);
    }

    @Schema(example="http://localhost:7990/bitbucket/projects/PROJECT_1/repos/rep_1/browse?at=996b4f5a7e242a29fe573582d98f5174142bb97c")
    public String getBrowseUrl() {
        return this.getStringProperty(BROWSE_URL);
    }

    @Schema(example="0a943a29376f2336b78312d99e65da17048951db")
    public String getContentId() {
        return this.getStringProperty(CONTENT_ID);
    }

    public RestPath getPath() {
        return (RestPath)this.get(PATH);
    }

    @Schema(example="http://localhost:7990/bitbucket/projects/PROJECT_1/repos/rep_1/browse")
    public String getRepositoryUrl() {
        return this.getStringProperty(REPOSITORY_URL);
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY, example="SUBMODULE")
    public ContentTreeNode.Type getType() {
        return this.getEnumProperty(TYPE, ContentTreeNode.Type.class);
    }

    @Schema(example="ssh://git@localhost:7999/STASH/stash.git")
    public String getUrl() {
        return this.getStringProperty(URL);
    }
}

