/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.deployment;

import com.atlassian.bitbucket.dmz.deployments.DeploymentSetRequest;
import com.atlassian.bitbucket.dmz.deployments.DeploymentState;
import com.atlassian.bitbucket.dmz.rest.v2.deployment.RestDeploymentEnvironment;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@JsonSerialize
public class RestDeploymentSetRequest
extends RestMapEntity {
    private static final String DEPLOYMENT_SEQUENCE_NUMBER = "deploymentSequenceNumber";
    private static final String DESCRIPTION = "description";
    private static final String DISPLAY_NAME = "displayName";
    private static final String ENVIRONMENT = "environment";
    private static final String KEY = "key";
    private static final String LAST_UPDATED = "lastUpdated";
    private static final String STATE = "state";
    private static final String URL = "url";

    public RestDeploymentSetRequest() {
    }

    public RestDeploymentSetRequest(@Nonnull DeploymentSetRequest request) {
        this(request.getDescription(), new RestDeploymentEnvironment("US East Mirror", "us-east-mirror", "production", "https://foo-bar.production/us-east"), request.getKey(), request.getLastUpdated(), request.getDisplayName(), request.getDeploymentSequenceNumber(), request.getState(), request.getUrl().toASCIIString());
    }

    private RestDeploymentSetRequest(Map<String, Object> values) {
        super(values);
    }

    private RestDeploymentSetRequest(@Nonnull String description, @Nonnull RestDeploymentEnvironment environment, @Nonnull String key, @Nullable Date lastUpdated, @Nonnull String displayName, long deploymentSequenceNumber, @Nullable DeploymentState state, @Nonnull String url) {
        this.put(DEPLOYMENT_SEQUENCE_NUMBER, deploymentSequenceNumber);
        this.put(DESCRIPTION, StringUtils.stripToNull((String)description));
        this.put(DISPLAY_NAME, StringUtils.stripToNull((String)displayName));
        this.put(ENVIRONMENT, environment);
        this.put(KEY, StringUtils.stripToNull((String)key));
        if (lastUpdated != null) {
            this.put(LAST_UPDATED, lastUpdated.getTime());
        }
        this.putIfNotNull(STATE, state);
        this.put(URL, StringUtils.stripToNull((String)url));
    }

    @Nullable
    public static RestDeploymentSetRequest valueOf(Object value) {
        if (value instanceof RestDeploymentSetRequest) {
            return (RestDeploymentSetRequest)value;
        }
        if (value instanceof Map) {
            return new RestDeploymentSetRequest((Map)value);
        }
        return null;
    }

    @Nonnull
    @NotNull(message="{bitbucket.deployment.sequence.number.required}")
    @Schema(example="2")
    public @NotNull(message="{bitbucket.deployment.sequence.number.required}") Long getDeploymentSequenceNumber() {
        try {
            return this.getLong(DEPLOYMENT_SEQUENCE_NUMBER);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nonnull
    @NotBlank(message="{bitbucket.deployment.deployment.description.required}")
    @Schema(example="2nd deployment of commit 44bca31f4be to US East production")
    @Size(max=255, message="{bitbucket.deployment.deployment.description.length.too.long}")
    public @NotBlank(message="{bitbucket.deployment.deployment.description.required}") @Size(max=255, message="{bitbucket.deployment.deployment.description.length.too.long}") String getDescription() {
        return this.getStringProperty(DESCRIPTION);
    }

    @Nonnull
    @NotBlank(message="{bitbucket.deployment.deployment.name.required}")
    @Schema(example="US East marketing website production")
    @Size(max=255, message="{bitbucket.deployment.deployment.name.length.too.long}")
    public @NotBlank(message="{bitbucket.deployment.deployment.name.required}") @Size(max=255, message="{bitbucket.deployment.deployment.name.length.too.long}") String getDisplayName() {
        return this.getStringProperty(DISPLAY_NAME);
    }

    @Nonnull
    @Schema(implementation=RestDeploymentEnvironment.class)
    @NotNull(message="{bitbucket.deployment.environment.required}")
    public @NotNull(message="{bitbucket.deployment.environment.required}") RestDeploymentEnvironment getEnvironment() {
        return RestDeploymentEnvironment.valueOf(this.get(ENVIRONMENT));
    }

    @Nonnull
    @NotBlank
    @Schema(example="marketing-us-prod")
    @Size(max=255, message="{bitbucket.deployment.deployment.key.length.too.long}")
    public @NotBlank @Size(max=255, message="{bitbucket.deployment.deployment.key.length.too.long}") String getKey() {
        return this.getStringProperty(KEY);
    }

    @Min(value=0L, message="{bitbucket.deployment.deployment.lastupdated.invalid}")
    @Nullable
    @Schema(example="1359075920")
    public @Min(value=0L, message="{bitbucket.deployment.deployment.lastupdated.invalid}") Long getLastUpdated() {
        try {
            return this.getLong(LAST_UPDATED);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    @Nonnull
    @NotNull(message="{bitbucket.deployment.state.required}")
    @Schema(example="SUCCESSFUL")
    public @NotNull(message="{bitbucket.deployment.state.required}") DeploymentState getState() {
        return DeploymentState.fromString((String)this.getStringProperty(STATE)).orElse(null);
    }

    @Nonnull
    @NotBlank(message="{bitbucket.deployment.deployment.url.required}")
    @Schema(example="https://my-dep-tool/marketing-us-prod/2")
    @Size(max=1024, message="{bitbucket.deployment.deployment.url.length.too.long}")
    public @NotBlank(message="{bitbucket.deployment.deployment.url.required}") @Size(max=1024, message="{bitbucket.deployment.deployment.url.length.too.long}") String getUrl() {
        return this.getStringProperty(URL);
    }

    private Long getLong(String property) throws NumberFormatException {
        Object value = this.get(property);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        return null;
    }
}

