/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.job;

import com.atlassian.bitbucket.job.JobMessage;
import com.atlassian.bitbucket.job.JobMessageSeverity;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

@JsonSerialize
@JsonSurrogate(value=JobMessage.class)
public class RestJobMessage
extends RestMapEntity {
    public static final String CREATED_DATE = "createdDate";
    public static final String ID = "id";
    public static final String SEVERITY = "severity";
    public static final String SUBJECT = "subject";
    public static final String TEXT = "text";

    public RestJobMessage(Map<String, ?> values) {
        super(values);
    }

    public RestJobMessage(@Nonnull JobMessage message) {
        Objects.requireNonNull(message, "message");
        this.put(CREATED_DATE, message.getCreatedDate().toEpochMilli());
        this.put(ID, message.getId());
        this.put(SEVERITY, message.getSeverity().name());
        message.getSubject().ifPresent(subject -> this.put(SUBJECT, subject));
        this.put(TEXT, message.getText());
    }

    public RestJobMessage(Date createdDate, long id, JobMessageSeverity severity, String subject, String text) {
        this.putIfNotNull(CREATED_DATE, createdDate);
        this.put(ID, id);
        this.putIfNotNull(SEVERITY, severity != null ? severity.name() : null);
        this.putIfNotNull(SUBJECT, subject);
        this.putIfNotNull(TEXT, text);
    }

    @Schema(example="1497657601250L")
    public Instant getCreatedDate() {
        return Instant.ofEpochMilli(this.getLongProperty(CREATED_DATE));
    }

    @Schema(example="617")
    public String getId() {
        return this.getStringProperty(ID);
    }

    public JobMessageSeverity getSeverity() {
        return JobMessageSeverity.valueOf((String)this.getStringProperty(SEVERITY));
    }

    @Schema(example="job")
    public String getSubject() {
        return this.getStringProperty(SUBJECT);
    }

    @Schema(example="Something of interest happened")
    public String getText() {
        return this.getStringProperty(TEXT);
    }
}

