/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.mail;

import com.atlassian.bitbucket.mail.MailAuthType;
import com.atlassian.bitbucket.mail.MailHostConfiguration;
import com.atlassian.bitbucket.mail.MailProtocol;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;

@JsonSerialize
public class RestMailConfiguration
extends RestMapEntity {
    public static final String AUTH_TYPE = "auth-type";
    public static final String HOSTNAME = "hostname";
    public static final String OAUTH2_PROVIDER_ID = "oauth2-provider-id";
    public static final String PASSWORD = "password";
    public static final String PORT = "port";
    public static final String PROTOCOL = "protocol";
    public static final String REQUIRE_START_TLS = "require-start-tls";
    public static final String SENDER_ADDRESS = "sender-address";
    public static final String TOKEN_ID = "token-id";
    public static final String USE_START_TLS = "use-start-tls";
    public static final String USERNAME = "username";

    public RestMailConfiguration() {
    }

    public RestMailConfiguration(MailHostConfiguration configuration, String senderAddress) {
        if (configuration != null) {
            this.put(AUTH_TYPE, configuration.getAuthType().name());
            this.put(HOSTNAME, configuration.getHostname());
            this.putIfNotNull(OAUTH2_PROVIDER_ID, configuration.getOauth2ProviderId());
            this.put(PORT, configuration.getPort());
            this.put(PROTOCOL, configuration.getProtocol().name());
            this.put(USE_START_TLS, configuration.isUseStartTls());
            this.put(REQUIRE_START_TLS, configuration.isRequireStartTls());
            this.putIfNotNull(TOKEN_ID, configuration.getTokenId());
            this.putIfNotNull(USERNAME, configuration.getUsername());
        }
        this.putIfNotNull(SENDER_ADDRESS, senderAddress);
    }

    public MailAuthType getAuthType() {
        String authType = this.getStringProperty(AUTH_TYPE);
        return authType == null ? null : MailAuthType.valueOf((String)authType);
    }

    @Schema(example="smtp.example.com")
    public String getHostname() {
        return this.getStringProperty(HOSTNAME);
    }

    public String getOauth2ProviderId() {
        return this.getStringProperty(OAUTH2_PROVIDER_ID);
    }

    @Schema(example="password")
    public String getPassword() {
        return this.getStringProperty(PASSWORD);
    }

    @Schema(example="465")
    public Integer getPort() {
        return this.getIntProperty(PORT);
    }

    public MailProtocol getProtocol() {
        String protocol = this.getStringProperty(PROTOCOL);
        return protocol == null ? null : MailProtocol.fromString((String)protocol);
    }

    @Schema(example="stash-no-reply@company.com")
    public String getSenderAddress() {
        return this.getStringProperty(SENDER_ADDRESS);
    }

    public String getTokenId() {
        return this.getStringProperty(TOKEN_ID);
    }

    @Schema(example="user")
    public String getUsername() {
        return this.getStringProperty(USERNAME);
    }

    public boolean isRequireStartTls() {
        return this.getBoolProperty(REQUIRE_START_TLS);
    }

    public boolean isUseStartTls() {
        return this.getBoolProperty(USE_START_TLS);
    }

    public void setPassword(String password) {
        this.putIfNotNull(PASSWORD, password);
    }
}

