/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.mergequeue;

import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueSettings;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionState;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.scope.RestScope;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

@JsonSurrogate(value=MergeQueueSettings.class)
public class RestMergeQueueSettings
extends RestMapEntity {
    private static final String ENABLED = "enabled";
    private static final String MERGE_TIMEOUT = "mergeTimeout";
    private static final String RESTRICTION_STATE = "restrictionState";
    private static final String SCOPE = "scope";

    public RestMergeQueueSettings() {
    }

    public RestMergeQueueSettings(@Nonnull MergeQueueSettings settings) {
        this(settings, null);
    }

    public RestMergeQueueSettings(@Nonnull MergeQueueSettings settings, @Nullable ProjectSettingsRestrictionState restrictionState) {
        Objects.requireNonNull(settings, "settings");
        this.put(ENABLED, settings.isEnabled());
        this.put(SCOPE, new RestScope(settings.getScope()));
        this.put(MERGE_TIMEOUT, settings.getMergeTimeout().orElse(Duration.ZERO).getSeconds());
        this.put(RESTRICTION_STATE, restrictionState);
    }

    public Optional<Duration> getMergeTimeout() {
        long minutes = this.getLongProperty(MERGE_TIMEOUT);
        return minutes == 0L ? Optional.empty() : Optional.of(Duration.ofSeconds(minutes));
    }

    public ProjectSettingsRestrictionState getRestrictionState() {
        return this.getEnumProperty(RESTRICTION_STATE, ProjectSettingsRestrictionState.class);
    }

    public RestScope getScope() {
        return RestScope.valueOf(this.get(SCOPE));
    }

    public boolean isEnabled() {
        return this.getBoolProperty(ENABLED);
    }
}

