/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.mesh;

import com.atlassian.bitbucket.migration.MeshMigrationRequest;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Set;

@JsonSerialize
public class RestMeshMigrationRequest
extends RestMapEntity {
    public static final String ALL = "all";
    public static final String PROJECT_IDS = "projectIds";
    public static final String REPOSITORY_IDS = "repositoryIds";

    public RestMeshMigrationRequest() {
    }

    public RestMeshMigrationRequest(MeshMigrationRequest request) {
        this.put(ALL, request.isAll());
        this.putIfNotNull(REPOSITORY_IDS, request.getRepositoryIds());
        this.putIfNotEmpty(PROJECT_IDS, request.getProjectIds());
    }

    public RestMeshMigrationRequest(Map value) {
        super(value);
    }

    @Nonnull
    public Set<Integer> getProjectIds() {
        Object projectIds = this.get(PROJECT_IDS);
        return projectIds instanceof Iterable ? ImmutableSet.copyOf((Iterable)((Iterable)projectIds)) : ImmutableSet.of();
    }

    @Nonnull
    public Set<Integer> getRepositoryIds() {
        Object repositoryIds = this.get(REPOSITORY_IDS);
        return repositoryIds instanceof Iterable ? ImmutableSet.copyOf((Iterable)((Iterable)repositoryIds)) : ImmutableSet.of();
    }

    public boolean isAll() {
        return this.getBoolProperty(ALL);
    }
}

