/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.migration;

import com.atlassian.bitbucket.dmz.migration.MeshMigrationSummary;
import com.atlassian.bitbucket.dmz.rest.v2.migration.RestMeshMigrationQueueStateCounts;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;

@JsonSerialize
@JsonSurrogate(value=MeshMigrationSummary.class)
public class RestMeshMigrationSummary
extends RestMapEntity {
    public static String END_TIME = "endTime";
    public static String JOB_ID = "jobId";
    public static String PROGRESS = "progressPercentage";
    public static String QUEUE = "queueStateCounts";
    public static String START_TIME = "startTime";
    public static String STATE = "state";

    public RestMeshMigrationSummary() {
    }

    public RestMeshMigrationSummary(@Nonnull MeshMigrationSummary summary) {
        this.putIfNotNull(END_TIME, summary.getEndTime().map(Date::from).orElse(null));
        this.put(JOB_ID, summary.getJobId());
        this.put(PROGRESS, summary.getProgressPercentage());
        this.put(QUEUE, new RestMeshMigrationQueueStateCounts(summary.getQueueCountByState()));
        this.put(START_TIME, java.sql.Date.from(summary.getStartTime()));
        this.put(STATE, summary.getState());
    }

    @Nullable
    @Schema(example="1331038800000")
    public Long getEndTime() {
        Object date = this.get(END_TIME);
        if (date instanceof Long) {
            return (Long)date;
        }
        if (date instanceof Date) {
            return ((Date)date).getTime();
        }
        return null;
    }

    public long getJobId() {
        return this.getLongProperty(JOB_ID);
    }

    @Schema(example="53")
    public int getProgress() {
        return this.getIntProperty(PROGRESS);
    }

    public RestMeshMigrationQueueStateCounts getQueue() {
        return (RestMeshMigrationQueueStateCounts)this.get(QUEUE);
    }

    @Schema(example="1331038800000")
    public Long getStartTime() {
        Object date = this.get(START_TIME);
        if (date instanceof Long) {
            return (Long)date;
        }
        if (date instanceof Date) {
            return ((Date)date).getTime();
        }
        return null;
    }

    @Schema(example="RUNNING")
    public String getState() {
        return this.get(STATE).toString();
    }
}

