/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.migration;

import com.atlassian.bitbucket.dmz.rest.v2.migration.RestRepositorySelector;
import com.atlassian.bitbucket.migration.RepositoriesExportRequest;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@JsonSerialize
public class RestRepositoriesExportRequest
extends RestMapEntity {
    public static final String INCLUDES = "includes";

    public RestRepositoriesExportRequest() {
    }

    public RestRepositoriesExportRequest(Set<RestRepositorySelector> includes) {
        this.put(INCLUDES, includes);
    }

    public RestRepositoriesExportRequest(RepositoriesExportRequest request) {
        this.put(INCLUDES, request.getIncludes().stream().map(include -> new RestRepositorySelector(include.getProjectKey(), include.getSlug())).collect(Collectors.toSet()));
    }

    public RestRepositoriesExportRequest(Map value) {
        super(value);
    }

    @NotNull
    @Nonnull
    @Valid
    public Set<RestRepositorySelector> getIncludes() {
        return Optional.ofNullable((List)this.get(INCLUDES)).map(includes -> includes.stream().map(RestRepositorySelector::valueOf).filter(Objects::nonNull).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    @Nullable
    public static RestRepositoriesExportRequest valueOf(@Nullable Object value) {
        if (value instanceof RestRepositoriesExportRequest) {
            return (RestRepositoriesExportRequest)value;
        }
        if (value instanceof Map) {
            return new RestRepositoriesExportRequest((Map)value);
        }
        return null;
    }
}

