/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.pull;

import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestCommentActivity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.comment.RestComment;
import com.atlassian.bitbucket.rest.v2.api.content.RestCommentThreadDiffAnchor;
import com.atlassian.bitbucket.rest.v2.api.content.RestDiff;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;

@JsonSerialize
@JsonSurrogate(value=PullRequestCommentActivity.class)
public class RestPullRequestCommentActivity
extends RestPullRequestActivity {
    private static final String COMMENT = "comment";
    private static final String COMMENT_ACTION = "commentAction";
    private static final String COMMENT_ANCHOR = "commentAnchor";
    private static final String DIFF = "diff";

    public RestPullRequestCommentActivity(PullRequestCommentActivity activity) {
        this(activity.getId(), activity.getCreatedDate(), new RestApplicationUser(activity.getUser()), activity.getAction(), activity.getCommentAction(), new RestComment(activity.getComment()), activity.getComment().getAnchor().map(RestCommentThreadDiffAnchor::new).orElse(null), activity.getDiff().map(RestDiff.REST_TRANSFORM).orElse(null));
    }

    private RestPullRequestCommentActivity(long id, Date createdDate, RestApplicationUser restStashUser, PullRequestAction action, CommentAction commentAction, RestComment restComment, RestCommentThreadDiffAnchor restCommentThreadDiffAnchor, RestDiff restDiff) {
        super(id, createdDate, restStashUser, action);
        this.put(COMMENT_ACTION, commentAction);
        this.put(COMMENT, restComment);
        this.putIfNotNull(COMMENT_ANCHOR, restCommentThreadDiffAnchor);
        this.putIfNotNull(DIFF, restDiff);
    }

    public RestComment getComment() {
        return (RestComment)this.get(COMMENT);
    }

    public PullRequestAction getCommentAction() {
        return this.getEnumProperty(COMMENT_ACTION, PullRequestAction.class);
    }

    public RestCommentThreadDiffAnchor getCommentAnchor() {
        return (RestCommentThreadDiffAnchor)this.get(COMMENT_ANCHOR);
    }

    public RestDiff getDiff() {
        return (RestDiff)this.get(COMMENT_ANCHOR);
    }
}

