/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.pull;

import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestCommitMessageTemplate;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestMergeStrategy;
import com.atlassian.bitbucket.pull.PullRequestMergeConfig;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonSerialize
@JsonSurrogate(value=PullRequestMergeConfig.class)
public class RestPullRequestMergeConfig
extends RestMapEntity {
    private static final String COMMIT_MESSAGE_TEMPLATE = "commitMessageTemplate";
    private static final String COMMIT_SUMMARIES = "commitSummaries";
    private static final String DEFAULT_STRATEGY = "defaultStrategy";
    private static final String STRATEGIES = "strategies";
    private static final String TYPE = "type";

    public RestPullRequestMergeConfig() {
    }

    public RestPullRequestMergeConfig(PullRequestMergeConfig config) {
        this(config.getCommitMessageTemplate().map(RestPullRequestCommitMessageTemplate::new).orElse(null), config.getCommitSummaries(), new RestPullRequestMergeStrategy(config.getDefaultStrategy()), RestPullRequestMergeConfig.transform(config.getStrategies(), RestPullRequestMergeStrategy::new), config.getType().name());
    }

    protected RestPullRequestMergeConfig(Map<String, ?> values) {
        super(values);
    }

    private RestPullRequestMergeConfig(RestPullRequestCommitMessageTemplate commitMessageTemplate, int commitSummaries, RestPullRequestMergeStrategy defaultStrategy, Set<RestPullRequestMergeStrategy> strategies, String type) {
        this.putIfNotNull(COMMIT_MESSAGE_TEMPLATE, commitMessageTemplate);
        this.put(COMMIT_SUMMARIES, commitSummaries);
        this.put(DEFAULT_STRATEGY, defaultStrategy);
        this.put(STRATEGIES, strategies);
        this.putIfNotNull(TYPE, type);
    }

    @Nullable
    public static RestPullRequestMergeConfig valueOf(@Nullable Object value) {
        if (value instanceof RestPullRequestMergeConfig) {
            return (RestPullRequestMergeConfig)value;
        }
        if (value instanceof Map) {
            return new RestPullRequestMergeConfig((Map)value);
        }
        return null;
    }

    @Nullable
    public RestPullRequestCommitMessageTemplate getCommitMessageTemplate() {
        return RestPullRequestCommitMessageTemplate.valueOf(this.get(COMMIT_MESSAGE_TEMPLATE));
    }

    public int getCommitSummaries() {
        return this.getOptionalIntProperty(COMMIT_SUMMARIES).orElse(20);
    }

    @Nullable
    public RestPullRequestMergeStrategy getDefaultStrategy() {
        return RestPullRequestMergeStrategy.valueOf(this.get(DEFAULT_STRATEGY));
    }

    @ArraySchema(schema=@Schema(implementation=RestPullRequestMergeStrategy.class))
    @Nonnull
    public Set<RestPullRequestMergeStrategy> getStrategies() {
        Object strategies = this.get(STRATEGIES);
        if (strategies instanceof Iterable) {
            return (Set)MoreStreams.streamIterable((Iterable)((Iterable)strategies)).map(RestPullRequestMergeStrategy::valueOf).filter(Objects::nonNull).collect(MoreCollectors.toImmutableSet());
        }
        if (strategies instanceof RestPullRequestMergeStrategy) {
            return Collections.singleton((RestPullRequestMergeStrategy)strategies);
        }
        return Collections.emptySet();
    }

    @Schema(example="repository", accessMode=Schema.AccessMode.READ_ONLY)
    @Nullable
    public String getType() {
        return this.getStringProperty(TYPE);
    }
}

