/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.pull.automerge;

import com.atlassian.bitbucket.pull.automerge.AutoMergeProcessingResult;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequest;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class RestAutoMergeProcessingResult
extends RestMapEntity {
    private static final String AUTO_MERGE_PROCESSING_STATUS = "autoMergeProcessingStatus";
    private static final String PULL_REQUEST = "pullRequest";

    public RestAutoMergeProcessingResult(@Nonnull AutoMergeProcessingResult autoMergeProcessingResult) {
        Objects.requireNonNull(autoMergeProcessingResult, "autoMergeProcessingResult");
        this.put(AUTO_MERGE_PROCESSING_STATUS, autoMergeProcessingResult.getProcessingStatus());
        this.put(PULL_REQUEST, new RestPullRequest(autoMergeProcessingResult.getAutoMergeRequest().getPullRequest()));
    }

    @Nonnull
    @Schema(example="CANCELLED")
    public AutoMergeProcessingResult.AutoMergeProcessingStatus getAutoMergeProcessingStatus() {
        return this.getEnumProperty(AUTO_MERGE_PROCESSING_STATUS, AutoMergeProcessingResult.AutoMergeProcessingStatus.class);
    }

    @Nonnull
    @Schema(implementation=RestPullRequest.class)
    public RestPullRequest getPullRequest() {
        return (RestPullRequest)this.get(PULL_REQUEST);
    }
}

