/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.pull.automerge;

import com.atlassian.bitbucket.pull.automerge.AutoMergeSettings;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.scope.RestScope;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@JsonSurrogate(value=AutoMergeSettings.class)
public class RestAutoMergeSettings
extends RestMapEntity {
    private static final String ENABLED = "enabled";
    private static final String SCOPE = "scope";

    public RestAutoMergeSettings(@Nonnull AutoMergeSettings settings) {
        Objects.requireNonNull(settings, "settings");
        this.put(ENABLED, settings.isEnabled());
        this.put(SCOPE, new RestScope(settings.getScope()));
    }

    @Schema(example="false")
    public boolean getEnabled() {
        return this.getBoolProperty(ENABLED);
    }

    @Schema(description="The scope that these settings apply to.")
    public RestScope getScope() {
        return (RestScope)this.get(SCOPE);
    }
}

