/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.ratelimit;

import com.atlassian.bitbucket.dmz.rest.v2.ratelimit.RestTokenBucketSettings;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class RestBulkUserRateLimitSettingsUpdateRequest
extends RestMapEntity {
    public static final String USERS = "users";

    public RestBulkUserRateLimitSettingsUpdateRequest() {
    }

    public RestBulkUserRateLimitSettingsUpdateRequest(Map<String, ?> values) {
        super(values);
    }

    private RestBulkUserRateLimitSettingsUpdateRequest(Builder builder) {
        this.put(USERS, builder.usernames);
        this.put("settings", builder.settings);
        this.put("whitelisted", builder.whitelisted);
    }

    public RestTokenBucketSettings getSettings() {
        return RestTokenBucketSettings.valueOf(this.get("settings"));
    }

    @Nonnull
    public Set<String> getUsernames() {
        Object usernames = this.get(USERS);
        if (!(usernames instanceof Collection)) {
            return Collections.emptySet();
        }
        return (Set)((Collection)usernames).stream().filter(Objects::nonNull).map(Object::toString).collect(MoreCollectors.toImmutableSet());
    }

    public boolean hasSettings() {
        return this.get("settings") != null;
    }

    public boolean isWhitelisted() {
        return this.getBoolProperty("whitelisted");
    }

    public static class Builder {
        private final Set<String> usernames;
        private RestTokenBucketSettings settings;
        private boolean whitelisted;

        public Builder(@Nonnull Set<String> usernames) {
            this.usernames = ImmutableSet.copyOf((Collection)Objects.requireNonNull(usernames, "usernames"));
        }

        public RestBulkUserRateLimitSettingsUpdateRequest build() {
            return new RestBulkUserRateLimitSettingsUpdateRequest(this);
        }

        public Builder whitelisted() {
            this.whitelisted = true;
            return this;
        }

        public Builder withSettings(@Nonnull RestTokenBucketSettings settings) {
            this.settings = Objects.requireNonNull(settings, "settings");
            return this;
        }
    }
}

