/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.secretscanning;

import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningRule;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;

public class RestSecretScanningAllowlistRule
extends RestMapEntity {
    private static final String ID = "id";
    private static final String LINE_REGEX = "lineRegex";
    private static final String NAME = "name";
    private static final String PATH_REGEX = "pathRegex";

    public RestSecretScanningAllowlistRule() {
    }

    public RestSecretScanningAllowlistRule(Map<String, ?> values) {
        super(values);
    }

    public RestSecretScanningAllowlistRule(long id, @Nonnull String name, @Nullable String lineRegex, @Nullable String pathRegex) {
        this.put(ID, id);
        this.put(NAME, Objects.requireNonNull(name, NAME));
        this.putIfNotNull(LINE_REGEX, lineRegex);
        this.putIfNotNull(PATH_REGEX, pathRegex);
    }

    public RestSecretScanningAllowlistRule(DmzSecretScanningRule rule) {
        this(rule.getId(), rule.getName(), rule.getLineRegex().orElse(null), rule.getPathRegex().orElse(null));
    }

    @Schema(description="The ID of the rule", example="7")
    public long getId() {
        return this.getLongProperty(ID);
    }

    @Schema(description="If present, regular expression for matching a secret on a code line", example="(BBDC-[a-zA-Z0-9+]{44})")
    @Nullable
    public String getLineRegex() {
        return this.getStringProperty(LINE_REGEX);
    }

    @Schema(description="Human readable name for the rule", example="Bitbucket DC HTTP access token")
    @Nonnull
    public String getName() {
        return this.getStringProperty(NAME);
    }

    @Schema(description="If present, regular expression matching file names", example="*.pem")
    @Nullable
    public String getPathRegex() {
        return this.getStringProperty(PATH_REGEX);
    }
}

