/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.settingsrestriction;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.project.RestProject;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestriction;
import com.atlassian.bitbucket.settingsrestriction.RestrictionProcessedState;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;

@JsonSurrogate(value=ProjectSettingsRestriction.class)
public class RestProjectSettingsRestriction
extends RestMapEntity {
    private static final String COMPONENT_KEY = "componentKey";
    private static final String FEATURE_KEY = "featureKey";
    private static final String NAMESPACE = "namespace";
    private static final String PROCESSED_STATE = "processedState";
    private static final String PROJECT = "project";

    public RestProjectSettingsRestriction() {
    }

    public RestProjectSettingsRestriction(@Nonnull ProjectSettingsRestriction restriction) {
        restriction.getSettingsKey().getComponentKey().ifPresent(componentKey -> this.put(COMPONENT_KEY, componentKey));
        this.put(FEATURE_KEY, restriction.getSettingsKey().getFeatureKey());
        this.put(NAMESPACE, restriction.getSettingsKey().getNamespace());
        this.put(PROCESSED_STATE, restriction.getProcessedState());
        this.put(PROJECT, new RestProject(restriction.getProject()));
    }

    @Schema(example="my-admin-component")
    public String getComponentKey() {
        return this.getStringProperty(COMPONENT_KEY);
    }

    @Schema(example="my-admin-feature")
    public String getFeatureKey() {
        return this.getStringProperty(FEATURE_KEY);
    }

    @Schema(example="org.featuredeveloper")
    public String getNamespace() {
        return this.getStringProperty(NAMESPACE);
    }

    public RestProject getProject() {
        return RestProject.valueOf(this.get(PROJECT));
    }

    @Schema(example="PROCESSED")
    public RestrictionProcessedState getProcessedState() {
        return this.getEnumProperty(PROCESSED_STATE, RestrictionProcessedState.class, null);
    }
}

