/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.settingsrestriction;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;

@JsonSerialize
public class RestProjectSettingsRestrictionRequest
extends RestMapEntity {
    private static final String COMPONENT_KEY = "componentKey";
    private static final String FEATURE_KEY = "featureKey";
    private static final String NAMESPACE = "namespace";

    public RestProjectSettingsRestrictionRequest() {
    }

    public RestProjectSettingsRestrictionRequest(String namespace, String featureKey) {
        this(namespace, featureKey, null);
    }

    public RestProjectSettingsRestrictionRequest(String namespace, String featureKey, String componentKey) {
        this.put(FEATURE_KEY, featureKey);
        this.put(NAMESPACE, namespace);
        this.putIfNotNull(COMPONENT_KEY, componentKey);
    }

    @OptionalString(minimumSize=2, size=255)
    @Schema(example="my-admin-component")
    public String getComponentKey() {
        return this.getStringProperty(COMPONENT_KEY);
    }

    @RequiredString(size=255)
    @Schema(example="my-admin-feature", required=true)
    public String getFeatureKey() {
        return this.getStringProperty(FEATURE_KEY);
    }

    @RequiredString(size=255)
    @Schema(example="org.featuredeveloper", required=true)
    public String getNamespace() {
        return this.getStringProperty(NAMESPACE);
    }
}

