/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.user;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermittedUser;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.function.Function;

@JsonSerialize
@JsonSurrogate(value=PermittedUser.class)
public class RestPermittedUser
extends RestMapEntity {
    public static final Function<PermittedUser, RestPermittedUser> REST_TRANSFORM = RestPermittedUser::fromPermittedUser;
    private static final String PERMISSION = "permission";
    private static final String USER = "user";

    public RestPermittedUser(PermittedUser permittedUser) {
        this(permittedUser.getUser(), permittedUser.getPermission());
    }

    private RestPermittedUser(ApplicationUser stashUser, Permission permission) {
        this.put(USER, new RestApplicationUser(stashUser));
        this.put(PERMISSION, permission.name());
    }

    public Permission getPermission() {
        return this.getEnumProperty(PERMISSION, Permission.class);
    }

    public RestApplicationUser getUser() {
        return (RestApplicationUser)this.get(USER);
    }

    public static RestPermittedUser fromPermittedUser(PermittedUser permittedUser) {
        return permittedUser == null ? null : new RestPermittedUser(permittedUser);
    }
}

