/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.util;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.rest.v2.api.BadRequestException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class RestPermissionUtils {
    private RestPermissionUtils() {
        throw new UnsupportedOperationException(RestPermissionUtils.class.getName() + " should not be instantiated");
    }

    @Nullable
    public static Permission parsePermission(@Nonnull I18nService i18nService, @Nullable String permission, @Nullable Class<?> resourceType) {
        return RestPermissionUtils.parsePermission(i18nService, permission, resourceType, null, null);
    }

    @Nullable
    public static Permission parsePermission(@Nonnull I18nService i18nService, @Nullable String permission, @Nullable Class<?> resourceType, @Nullable Permission defaultPermission, @Nullable String context) {
        Objects.requireNonNull(i18nService, "i18nService");
        if (StringUtils.isNotBlank((CharSequence)permission)) {
            Permission permissionLevel;
            try {
                permissionLevel = Permission.valueOf((String)permission.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(context, i18nService.getMessage("bitbucket.rest.permission.invalid", new Object[]{permission}));
            }
            if (resourceType == null || permissionLevel.isResource(resourceType)) {
                return permissionLevel;
            }
            throw new BadRequestException(context, i18nService.getMessage("bitbucket.rest.permission.invalidresource", new Object[]{permissionLevel, resourceType.getSimpleName()}));
        }
        return defaultPermission;
    }
}

