/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.enrich;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.avatar.AvatarService;
import com.atlassian.bitbucket.dmz.rest.v2.pull.reviewer.RestReviewerGroup;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.reviewer.ReviewerGroup;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.v2.api.enrich.EnrichProcessor;
import com.atlassian.bitbucket.rest.v2.api.project.RestProject;
import com.atlassian.bitbucket.rest.v2.api.user.RestPerson;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class DefaultAvatarEnricher
implements AvatarEnricher {
    private final AvatarService avatarService;

    public DefaultAvatarEnricher(AvatarService avatarService) {
        this.avatarService = avatarService;
    }

    @Override
    public void enrich(@Nonnull Object entity, @Nullable AvatarRequest avatarRequest) {
        if (avatarRequest != null) {
            try (Timer ignored = TimerUtils.start((String)"AvatarEnricher.enrich");){
                this.setAvatarUrls(entity, avatarRequest);
            }
        }
    }

    private void setAvatarUrls(Object entity, AvatarRequest request) {
        EnrichProcessor.processEntities(entity, e -> {
            if (e instanceof RestPerson) {
                RestPerson person = (RestPerson)e;
                person.setAvatarUrl(this.avatarService.getUrlForPerson((Person)person, request));
            } else if (e instanceof RestProject) {
                RestProject project = (RestProject)e;
                project.setAvatarUrl(this.avatarService.getUrlForProject((Project)project, request));
            } else if (e instanceof RestReviewerGroup) {
                RestReviewerGroup group = (RestReviewerGroup)e;
                group.setAvatarUrl(this.avatarService.getUrlForReviewerGroup((ReviewerGroup)group, request));
            }
            return e;
        });
    }
}

