/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.enrich;

import com.atlassian.bitbucket.markup.MarkupService;
import com.atlassian.bitbucket.markup.RenderContext;
import com.atlassian.bitbucket.rest.v2.api.comment.RestComment;
import com.atlassian.bitbucket.rest.v2.api.enrich.EnrichProcessor;
import com.atlassian.bitbucket.rest.v2.api.enrich.MarkupEnricher;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequest;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class DefaultMarkupEnricher
implements MarkupEnricher {
    private static final RenderContext EMPTY_CONTEXT = new RenderContext.Builder().build();
    private final MarkupService markupService;

    public DefaultMarkupEnricher(MarkupService markupService) {
        this.markupService = markupService;
    }

    @Override
    @Nonnull
    public Object enrich(@Nonnull Object entityToEnrich) {
        return EnrichProcessor.processEntities(entityToEnrich, entity -> {
            if (entity instanceof RestComment) {
                RestComment comment = (RestComment)entity;
                comment.setHtml(this.render(comment.getText(), this.createRenderContext(comment)));
            } else if (entity instanceof RestPullRequest) {
                RestPullRequest pullRequest = (RestPullRequest)entity;
                pullRequest.setHtmlDescription(this.render(pullRequest.getDescription(), this.createRenderContext(pullRequest)));
            }
            return entity;
        });
    }

    private RenderContext createRenderContext(RestComment comment) {
        if (comment.getProperties() == null) {
            return EMPTY_CONTEXT;
        }
        return new RenderContext.Builder().data(comment.getProperties()).build();
    }

    private RenderContext createRenderContext(RestPullRequest pullRequest) {
        if (pullRequest.getToRef().getRepository().getId() < 0) {
            return EMPTY_CONTEXT;
        }
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("repositoryId", pullRequest.getToRef().getRepository().getId());
        return new RenderContext.Builder().data(properties).build();
    }

    private String render(String text, RenderContext context) {
        return StringUtils.isEmpty((CharSequence)text) ? text : this.markupService.render(text, context);
    }
}

