/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.exception;

import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.validation.ConstraintNature;
import com.google.common.base.MoreObjects;
import jakarta.inject.Singleton;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

@Provider
@Singleton
public class ConstraintViolationExceptionMapper
implements ExceptionMapper<ConstraintViolationException> {
    public Response toResponse(ConstraintViolationException exception) {
        RestErrors.Builder errors = new RestErrors.Builder();
        Response.Status status = null;
        for (ConstraintViolation violation : exception.getConstraintViolations()) {
            status = violation.getConstraintDescriptor().getPayload().contains(ConstraintNature.Conflict.class) && status != Response.Status.BAD_REQUEST ? Response.Status.CONFLICT : Response.Status.BAD_REQUEST;
            errors.add(new RestErrorMessage(violation.getPropertyPath().toString(), violation.getMessage()));
        }
        return ResponseFactory.status((Response.Status)MoreObjects.firstNonNull(status, (Object)Response.Status.BAD_REQUEST)).entity((Object)errors.build()).type("application/json;charset=UTF-8").build();
    }
}

