/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.exception;

import com.atlassian.bitbucket.EntityMovedException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.util.RedirectUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.net.URI;
import java.util.Optional;

@Provider
@Singleton
public class EntityMovedExceptionMapper
implements ExceptionMapper<EntityMovedException> {
    private final NavBuilder navBuilder;
    private final RequestManager requestManager;
    private final ExceptionMapper<ServiceException> serviceExceptionMapper;

    @Inject
    public EntityMovedExceptionMapper(NavBuilder navBuilder, RequestManager requestManager, ExceptionMapper<ServiceException> serviceExceptionMapper) {
        this.navBuilder = navBuilder;
        this.requestManager = requestManager;
        this.serviceExceptionMapper = serviceExceptionMapper;
    }

    public Response toResponse(EntityMovedException exception) {
        HttpServletRequest request = (HttpServletRequest)this.requestManager.getRequestContext().getRawRequest();
        Optional redirect = RedirectUtils.getRedirectUrl((HttpServletRequest)request, (EntityMovedException)exception);
        if (redirect.isPresent()) {
            URI pathUri = UriBuilder.fromUri((String)((String)redirect.get())).build(new Object[0]);
            URI redirectUri = UriBuilder.fromUri((String)this.navBuilder.buildAbsolute()).replacePath(pathUri.getPath()).replaceQuery(pathUri.getRawQuery()).build(new Object[0]);
            return Response.temporaryRedirect((URI)redirectUri).entity((Object)("Resource has moved to " + (String)redirect.get())).build();
        }
        return this.serviceExceptionMapper.toResponse((Throwable)exception);
    }
}

