/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.exception;

import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.validation.FormErrors;
import com.atlassian.bitbucket.validation.FormValidationException;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.Collection;
import java.util.Map;

@Provider
@Singleton
public class FormValidationExceptionMapper
implements ExceptionMapper<FormValidationException> {
    public Response toResponse(FormValidationException exception) {
        RestErrors.Builder errors = new RestErrors.Builder();
        FormErrors formErrors = exception.getErrors();
        for (String string : formErrors.getFormErrors()) {
            errors.add(new RestErrorMessage(string));
        }
        for (Map.Entry entry : formErrors.getFieldErrors().entrySet()) {
            for (String message : (Collection)entry.getValue()) {
                errors.add(new RestErrorMessage((String)entry.getKey(), message));
            }
        }
        return ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)errors.build()).type("application/json;charset=UTF-8").build();
    }
}

