/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.exception;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

@Provider
@Singleton
public class NoSuchEntityExceptionMapper
implements ExceptionMapper<NoSuchEntityException> {
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final ExceptionMapper<ServiceException> serviceExceptionMapper;

    public NoSuchEntityExceptionMapper(AuthenticationContext authenticationContext, I18nService i18nService, ExceptionMapper<ServiceException> serviceExceptionMapper) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.serviceExceptionMapper = serviceExceptionMapper;
    }

    public Response toResponse(NoSuchEntityException exception) {
        if (!this.authenticationContext.isAuthenticated()) {
            return ResponseFactory.status(Response.Status.UNAUTHORIZED).entity((Object)new RestErrorMessage(this.i18nService.getMessage("bitbucket.rest.service.accessdenied", new Object[0]))).type("application/json;charset=UTF-8").build();
        }
        return this.serviceExceptionMapper.toResponse((Throwable)exception);
    }
}

