/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.exception;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import jakarta.annotation.Priority;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

@Priority(value=4990)
@Provider
@Singleton
public class SecurityExceptionMapper
implements ExceptionMapper<SecurityException> {
    private final I18nService i18nService;

    public SecurityExceptionMapper(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public Response toResponse(SecurityException exception) {
        return ResponseFactory.status(Response.Status.UNAUTHORIZED).entity((Object)new RestErrors(new RestErrorMessage(null, this.i18nService.getMessage("bitbucket.rest.service.accessdenied", new Object[0]), exception.getClass().getName()))).type("application/json;charset=UTF-8").build();
    }
}

