/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.exception;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.EntityOutOfDateException;
import com.atlassian.bitbucket.FeatureDisabledException;
import com.atlassian.bitbucket.ForbiddenException;
import com.atlassian.bitbucket.IllegalEntityStateException;
import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.RequestCanceledException;
import com.atlassian.bitbucket.ResourceBusyException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.attachment.InvalidAttachmentMetadataException;
import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.auth.AuthenticationRequiredException;
import com.atlassian.bitbucket.auth.AuthenticationSystemException;
import com.atlassian.bitbucket.auth.CaptchaAuthenticationException;
import com.atlassian.bitbucket.content.FileTranscodingException;
import com.atlassian.bitbucket.dmz.deployments.DeploymentAlreadyExistsException;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplicaAlreadyExistsException;
import com.atlassian.bitbucket.dmz.rest.v2.RestEntityOutOfDateErrorMessage;
import com.atlassian.bitbucket.dmz.rest.v2.RestRequestCanceledMessage;
import com.atlassian.bitbucket.dmz.rest.v2.auth.RestAuthenticationRequiredErrorMessage;
import com.atlassian.bitbucket.dmz.rest.v2.hook.repository.RestRepositoryHookVetoedMessage;
import com.atlassian.bitbucket.dmz.rest.v2.mesh.RestInvalidMeshNodeUrlMessage;
import com.atlassian.bitbucket.dmz.rest.v2.mesh.RestMeshNodeNameAlreadyExistsMessage;
import com.atlassian.bitbucket.dmz.rest.v2.mesh.RestMeshNodeUrlAlreadyExistsMessage;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestDuplicatePullRequestErrorMessage;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestInvalidPullRequestReviewersErrorMessage;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestMergeVetoedErrorMessage;
import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestOutOfDateErrorMessage;
import com.atlassian.bitbucket.dmz.rest.v2.repository.RestDuplicateRefMessage;
import com.atlassian.bitbucket.dmz.rest.v2.repository.RestInvalidRefNameMessage;
import com.atlassian.bitbucket.dmz.rest.v2.scm.RestMergeErrorMessage;
import com.atlassian.bitbucket.dmz.x509.X509CertificateIOException;
import com.atlassian.bitbucket.hook.repository.RepositoryHookVetoedException;
import com.atlassian.bitbucket.internal.rest.renderer.AggregateBuilder;
import com.atlassian.bitbucket.license.InvalidLicenseException;
import com.atlassian.bitbucket.license.LicenseLimitException;
import com.atlassian.bitbucket.license.LimitExceededException;
import com.atlassian.bitbucket.migration.MaxConcurrentMigrationJobsException;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.pull.DuplicatePullRequestException;
import com.atlassian.bitbucket.pull.InvalidPullRequestReviewersException;
import com.atlassian.bitbucket.pull.PullRequestMergeVetoedException;
import com.atlassian.bitbucket.pull.UnmodifiablePullRequestRoleException;
import com.atlassian.bitbucket.pull.automerge.AutoMergeNotRequestedException;
import com.atlassian.bitbucket.repository.ArchiveRepositoryFailedException;
import com.atlassian.bitbucket.repository.ConflictingRefNameException;
import com.atlassian.bitbucket.repository.RepositoryOfflineException;
import com.atlassian.bitbucket.repository.RepositoryReadOnlyException;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.exception.PluginNotAvailableException;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.scm.CommandUsageException;
import com.atlassian.bitbucket.scm.IncompleteScmException;
import com.atlassian.bitbucket.scm.MergeException;
import com.atlassian.bitbucket.scm.signed.SigningFailedException;
import com.atlassian.bitbucket.util.PageStartOutOfBoundsException;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Singleton
public class ServiceExceptionMapper
implements ExceptionMapper<ServiceException> {
    public static final Map<Class<? extends ServiceException>, Response.Status> STATUS_MAP;
    private static final Logger log;
    private final AggregateBuilder exceptionMessageBuilder;

    public ServiceExceptionMapper(NavBuilder navBuilder) {
        this.exceptionMessageBuilder = new AggregateBuilder(navBuilder);
        this.registerSurrogate(RestAuthenticationRequiredErrorMessage.class);
        this.registerSurrogate(RestDuplicatePullRequestErrorMessage.class);
        this.registerSurrogate(RestDuplicateRefMessage.class);
        this.registerSurrogate(RestEntityOutOfDateErrorMessage.class);
        this.registerSurrogate(RestErrorMessage.class);
        this.registerSurrogate(RestInvalidMeshNodeUrlMessage.class);
        this.registerSurrogate(RestInvalidPullRequestReviewersErrorMessage.class);
        this.registerSurrogate(RestInvalidRefNameMessage.class);
        this.registerSurrogate(RestMergeErrorMessage.class);
        this.registerSurrogate(RestMeshNodeNameAlreadyExistsMessage.class);
        this.registerSurrogate(RestMeshNodeUrlAlreadyExistsMessage.class);
        this.registerSurrogate(RestPullRequestMergeVetoedErrorMessage.class);
        this.registerSurrogate(RestPullRequestOutOfDateErrorMessage.class);
        this.registerSurrogate(RestRepositoryHookVetoedMessage.class);
        this.registerSurrogate(RestRequestCanceledMessage.class);
    }

    public Response toResponse(ServiceException e) {
        RestErrors errors = new RestErrors((RestErrorMessage)this.exceptionMessageBuilder.buildFor(e));
        Response response = this.createResponseBuilder(e).entity((Object)errors).type("application/json;charset=UTF-8").build();
        log.debug("Mapping {} to REST response {} - {}", new Object[]{e.getClass().getSimpleName(), response.getStatus(), e.getMessage()});
        return response;
    }

    private Response.ResponseBuilder createResponseBuilder(ServiceException e) {
        Class<?> clazz = e.getClass();
        while (ServiceException.class.isAssignableFrom(clazz)) {
            Response.Status status = STATUS_MAP.get(clazz);
            if (status != null) {
                return ResponseFactory.status(status);
            }
            clazz = clazz.getSuperclass();
        }
        return ResponseFactory.serverError();
    }

    private void registerSurrogate(Class<? extends RestErrorMessage> surrogateClass) {
        Preconditions.checkArgument((boolean)surrogateClass.isAnnotationPresent(JsonSurrogate.class), (Object)(surrogateClass.getName() + " is not annotated as a surrogate"));
        Preconditions.checkArgument((boolean)RestErrorMessage.class.isAssignableFrom(surrogateClass), (Object)(surrogateClass.getName() + " must derive from RestErrorMessage"));
        Preconditions.checkArgument((boolean)ServiceException.class.isAssignableFrom(surrogateClass.getAnnotation(JsonSurrogate.class).value()), (Object)(surrogateClass.getAnnotation(JsonSurrogate.class).value().getName() + " must derive from ServiceException"));
        this.exceptionMessageBuilder.registerSurrogate(surrogateClass);
    }

    static {
        log = LoggerFactory.getLogger(ServiceExceptionMapper.class);
        STATUS_MAP = ImmutableMap.builder().put(ArgumentValidationException.class, (Object)Response.Status.BAD_REQUEST).put(AuthenticationSystemException.class, (Object)Response.Status.INTERNAL_SERVER_ERROR).put(AuthenticationException.class, (Object)Response.Status.UNAUTHORIZED).put(AuthenticationRequiredException.class, (Object)Response.Status.OK).put(AuthorisationException.class, (Object)Response.Status.UNAUTHORIZED).put(AutoMergeNotRequestedException.class, (Object)Response.Status.BAD_REQUEST).put(CaptchaAuthenticationException.class, (Object)Response.Status.UNAUTHORIZED).put(CommandUsageException.class, (Object)Response.Status.BAD_REQUEST).put(ConflictingRefNameException.class, (Object)Response.Status.CONFLICT).put(DuplicatePullRequestException.class, (Object)Response.Status.CONFLICT).put(EntityOutOfDateException.class, (Object)Response.Status.CONFLICT).put(FeatureDisabledException.class, (Object)Response.Status.CONFLICT).put(FileTranscodingException.class, (Object)Response.Status.UNSUPPORTED_MEDIA_TYPE).put(ForbiddenException.class, (Object)Response.Status.FORBIDDEN).put(IllegalEntityStateException.class, (Object)Response.Status.CONFLICT).put(IntegrityException.class, (Object)Response.Status.CONFLICT).put(IncompleteScmException.class, (Object)Response.Status.NOT_FOUND).put(InvalidAttachmentMetadataException.class, (Object)Response.Status.BAD_REQUEST).put(InvalidPullRequestReviewersException.class, (Object)Response.Status.CONFLICT).put(InvalidLicenseException.class, (Object)Response.Status.BAD_REQUEST).put(LicenseLimitException.class, (Object)Response.Status.FORBIDDEN).put(LimitExceededException.class, (Object)Response.Status.BAD_REQUEST).put(MaxConcurrentMigrationJobsException.class, (Object)Response.Status.SERVICE_UNAVAILABLE).put(MergeException.class, (Object)Response.Status.CONFLICT).put(MeshPartitionReplicaAlreadyExistsException.class, (Object)Response.Status.CONFLICT).put(NoSuchEntityException.class, (Object)Response.Status.NOT_FOUND).put(PageStartOutOfBoundsException.class, (Object)Response.Status.NOT_FOUND).put(PluginNotAvailableException.class, (Object)Response.Status.NOT_FOUND).put(PullRequestMergeVetoedException.class, (Object)Response.Status.CONFLICT).put(ArchiveRepositoryFailedException.class, (Object)Response.Status.FORBIDDEN).put(RepositoryHookVetoedException.class, (Object)Response.Status.BAD_REQUEST).put(RepositoryOfflineException.class, (Object)Response.Status.SERVICE_UNAVAILABLE).put(RepositoryReadOnlyException.class, (Object)Response.Status.FORBIDDEN).put(RequestCanceledException.class, (Object)Response.Status.BAD_REQUEST).put(ResourceBusyException.class, (Object)Response.Status.SERVICE_UNAVAILABLE).put(SigningFailedException.class, (Object)Response.Status.INTERNAL_SERVER_ERROR).put(UnmodifiablePullRequestRoleException.class, (Object)Response.Status.CONFLICT).put(DeploymentAlreadyExistsException.class, (Object)Response.Status.CONFLICT).put(X509CertificateIOException.class, (Object)Response.Status.BAD_REQUEST).build();
    }
}

