/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.exception;

import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.request.RequestMetadata;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Singleton
public class UnhandledExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger log = LoggerFactory.getLogger(UnhandledExceptionMapper.class);
    private final Map<Class<?>, ExceptionMapper<?>> mappers;
    private final RequestManager requestManager;

    @Inject
    public UnhandledExceptionMapper(RequestManager requestManager, List<ExceptionMapper<?>> exceptionMappers) {
        this.requestManager = requestManager;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        exceptionMappers.forEach(instance -> builder.put(this.getHandledException(instance.getClass()), instance));
        this.mappers = builder.build();
    }

    public Response toResponse(Exception exception) {
        if (exception.getClass().getName().equals("org.glassfish.hk2.api.MultiException")) {
            exception = (Exception)exception.getCause();
        }
        Class<?> exceptionClass = exception.getClass();
        while (!exceptionClass.equals(Exception.class)) {
            Response response;
            ExceptionMapper<?> mapper = this.mappers.get(exceptionClass);
            if (mapper != null && (response = mapper.toResponse((Throwable)exception)) != null) {
                return response;
            }
            exceptionClass = exceptionClass.getSuperclass();
        }
        RequestMetadata metadata = this.requestManager.getRequestMetadata();
        if (metadata == null) {
            log.error("Unhandled exception while processing REST request, but no request is active", (Throwable)exception);
        } else {
            log.error("Unhandled exception while processing REST request: {}", (Object)metadata.getAction(), (Object)exception);
        }
        return this.handleDefault(exception);
    }

    @VisibleForTesting
    int getRegisteredExceptionCount() {
        return this.mappers.size();
    }

    private Class<? extends Throwable> getExceptionFromClass(Class<? extends ExceptionMapper<?>> clazz) {
        for (Type declaredInterface : clazz.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            Class cls;
            if (declaredInterface instanceof Class && ExceptionMapper.class.isAssignableFrom(cls = (Class)declaredInterface)) {
                return this.getExceptionFromClass(clazz);
            }
            if (!(declaredInterface instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)declaredInterface).getRawType() != ExceptionMapper.class) continue;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    private Class<?> getHandledException(Class<? extends ExceptionMapper<?>> exceptionHandlerClass) {
        Class<? extends Throwable> exception = this.getExceptionFromClass(exceptionHandlerClass);
        if (exception != null) {
            return exception;
        }
        throw new RuntimeException("Could not find exception class for " + exceptionHandlerClass.getName());
    }

    private Response handleDefault(Exception exception) {
        RequestMetadata metadata = this.requestManager.getRequestMetadata();
        if (metadata == null) {
            log.error("Unhandled exception while processing REST request, but no request is active", (Throwable)exception);
        } else {
            log.error("Unhandled exception while processing REST request: {}", (Object)metadata.getAction(), (Object)exception);
        }
        return ResponseFactory.status(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new RestErrors("An error occurred while processing the request. Check the server logs for more information.")).type("application/json;charset=UTF-8").build();
    }
}

