/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.exception;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.exception.WebSudoRequiredException;
import jakarta.annotation.Priority;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

@Priority(value=4990)
@Provider
@Singleton
public class WebSudoRequiredExceptionMapper
implements ExceptionMapper<WebSudoRequiredException> {
    private final I18nService i18nService;

    public WebSudoRequiredExceptionMapper(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public Response toResponse(WebSudoRequiredException exception) {
        return ResponseFactory.status(Response.Status.UNAUTHORIZED).entity((Object)new RestErrors(new RestErrorMessage(null, this.i18nService.getMessage("bitbucket.rest.websudo.required", new Object[]{exception})))).type("application/json;charset=UTF-8").build();
    }
}

