/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.filter;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.filter.ResourceFilterProvider;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;

public class EmptyBodyFilterProvider
implements ResourceFilterProvider {
    private static Set<String> mutatingVerbs = ImmutableSet.of((Object)"POST", (Object)"PUT", (Object)"PATCH", (Object)"DELETE");
    private final EmptyBodyFilter filter;

    @Inject
    public EmptyBodyFilterProvider(I18nService i18nService) {
        this.filter = new EmptyBodyFilter(i18nService);
    }

    @Override
    public void registerFilter(ResourceInfo resourceInfo, FeatureContext context) {
        Method method;
        String resourceClass = resourceInfo.getResourceClass().getName();
        if ((resourceClass.startsWith("com.atlassian.bitbucket") || resourceClass.startsWith("com.atlassian.stash")) && this.isMutating(method = resourceInfo.getResourceMethod())) {
            Parameter[] parameters;
            for (Parameter parameter : parameters = method.getParameters()) {
                Annotation[] annotations = parameter.getDeclaredAnnotations();
                if (annotations.length > 1 || !parameter.getType().getName().startsWith("com.atlassian.bitbucket") || annotations.length == 1 && annotations[0].annotationType() != Nonnull.class) continue;
                context.register((Object)this.filter);
            }
        }
    }

    private boolean isMutating(Method method) {
        return Arrays.stream(method.getDeclaredAnnotations()).anyMatch(annotation -> mutatingVerbs.contains(annotation.annotationType().getSimpleName().toUpperCase(Locale.ROOT)));
    }

    static class EmptyBodyFilter
    implements ContainerRequestFilter {
        private final I18nService i18nService;

        public EmptyBodyFilter(I18nService i18nService) {
            this.i18nService = i18nService;
        }

        public void filter(ContainerRequestContext requestContext) {
            if (!requestContext.hasEntity()) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.no.body", new Object[0]));
            }
        }
    }
}

