/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.filter;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.filter.ResourceFilterProvider;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarRequestHelper;
import com.atlassian.bitbucket.rest.v2.api.enrich.LinkEnricher;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;

public class EnricherResponseFilterProvider
implements ResourceFilterProvider {
    private final EnricherResponseFilter filter;

    @Inject
    public EnricherResponseFilterProvider(AvatarEnricher avatarEnricher, LinkEnricher linkEnricher, I18nService i18nService) {
        this.filter = new EnricherResponseFilter(avatarEnricher, linkEnricher, i18nService);
    }

    @Override
    public void registerFilter(ResourceInfo resourceInfo, FeatureContext context) {
        context.register((Object)this.filter);
    }

    static class EnricherResponseFilter
    implements ContainerResponseFilter {
        private final AvatarEnricher avatarEnricher;
        private final I18nService i18nService;
        private final LinkEnricher linkEnricher;

        public EnricherResponseFilter(AvatarEnricher avatarEnricher, LinkEnricher linkEnricher, I18nService i18nService) {
            this.avatarEnricher = avatarEnricher;
            this.linkEnricher = linkEnricher;
            this.i18nService = i18nService;
        }

        public void filter(ContainerRequestContext request, ContainerResponseContext response) {
            this.linkEnricher.enrich(response.getEntity());
            this.avatarEnricher.enrich(response.getEntity(), AvatarRequestHelper.makeAvatarRequest(request, this.i18nService));
        }
    }
}

