/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.filter;

import com.atlassian.bitbucket.internal.rest.filter.ResourceFilterProvider;
import com.atlassian.bitbucket.rest.v2.api.enrich.MarkupEnricher;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import java.io.IOException;
import java.util.List;

public class MarkupResponseFilterProvider
implements ResourceFilterProvider {
    private final MarkupResponseFilter filter;

    public MarkupResponseFilterProvider(MarkupEnricher enricher) {
        this.filter = new MarkupResponseFilter(enricher);
    }

    @Override
    public void registerFilter(ResourceInfo resourceInfo, FeatureContext context) {
        context.register((Object)this.filter);
    }

    static class MarkupResponseFilter
    implements ContainerResponseFilter {
        private final MarkupEnricher markupEnricher;

        public MarkupResponseFilter(MarkupEnricher markupEnricher) {
            this.markupEnricher = markupEnricher;
        }

        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            if (this.isQueryParamEnabled(requestContext, "markup")) {
                responseContext.setEntity(this.markupEnricher.enrich(responseContext.getEntity()));
            }
        }

        private boolean isQueryParamEnabled(ContainerRequestContext request, String key) {
            List values = (List)request.getUriInfo().getQueryParameters().get((Object)key);
            return values != null && values.size() > 0 && !values.contains("false");
        }
    }
}

