/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.filter;

import com.atlassian.bitbucket.dmz.mirror.MirrorAvailable;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.rest.filter.ResourceFilterProvider;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorFilter
implements ContainerRequestFilter,
ResourceFilterProvider {
    private static final Logger log = LoggerFactory.getLogger(MirrorFilter.class);
    private final ApplicationMode applicationMode;
    private final I18nService i18nService;

    public MirrorFilter(ApplicationPropertiesService applicationPropertiesService, I18nService i18nService) {
        this.i18nService = i18nService;
        this.applicationMode = applicationPropertiesService.getMode();
    }

    public void filter(@Nonnull ContainerRequestContext containerRequestContext) throws IOException {
        URI requestUri = containerRequestContext.getUriInfo().getRequestUri();
        String path = requestUri.getPath();
        if (path != null && this.isPathAllowed(path)) {
            log.trace("Path {} is allowed for mirrors", (Object)path);
            return;
        }
        containerRequestContext.abortWith(Response.status((int)403).entity((Object)new RestErrors.Builder().add(this.i18nService.getMessage("bitbucket.rest.mirroring.disabled", new Object[0])).build()).type("application/json").encoding("UTF-8").build());
    }

    @Override
    public void registerFilter(@Nonnull ResourceInfo resourceInfo, @Nonnull FeatureContext context) {
        Package packageElement;
        if (this.applicationMode == ApplicationMode.DEFAULT) {
            log.trace("Default application mode detected, not registering filter");
            return;
        }
        Class clazz = resourceInfo.getResourceClass();
        Method method = resourceInfo.getResourceMethod();
        boolean hasMirrorAvailableAnnotation = Stream.of(method, clazz, packageElement = clazz != null ? clazz.getPackage() : null).filter(Objects::nonNull).anyMatch(annotatedElement -> annotatedElement.isAnnotationPresent(MirrorAvailable.class));
        if (hasMirrorAvailableAnnotation) {
            return;
        }
        context.register((Object)this);
    }

    private boolean isPathAllowed(String path) {
        return Stream.of(AllowedPath.values()).anyMatch(allowedPath -> {
            if (path.contains(allowedPath.getComponent())) {
                return allowedPath.getSubPath().map(path::contains).orElse(true);
            }
            return false;
        });
    }

    private static enum AllowedPath {
        ANALYTICS_CONFIG_ENABLE("/rest/analytics", "config/enable"),
        ATST_ALL("/rest/troubleshooting"),
        PLUGINS_ANALYTICS_CLIENT("/rest/plugins", "com.atlassian.analytics.analytics-client-key");

        private final String component;
        private final String subPath;

        private AllowedPath(String component) {
            this(component, null);
        }

        private AllowedPath(String component, String subPath) {
            this.component = component;
            this.subPath = subPath;
        }

        @Nonnull
        public String getComponent() {
            return this.component;
        }

        @Nonnull
        public Optional<String> getSubPath() {
            return Optional.ofNullable(this.subPath);
        }
    }
}

