/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.filter;

import com.atlassian.bitbucket.dmz.auth.Anonymous2LORequestVerifier;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.SecurityService;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth1AnonymousAccessFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(OAuth1AnonymousAccessFilter.class);
    private final Anonymous2LORequestVerifier anonymous2LORequestVerifier;
    private final Set<Permission> permissions;
    private final SecurityService securityService;

    @Inject
    public OAuth1AnonymousAccessFilter(Anonymous2LORequestVerifier anonymous2LORequestVerifier, Set<Permission> permissions, SecurityService securityService) {
        Preconditions.checkArgument((!permissions.isEmpty() ? 1 : 0) != 0, (Object)"This filter should only be used when there are permissions to escalate");
        this.anonymous2LORequestVerifier = anonymous2LORequestVerifier;
        this.permissions = permissions;
        this.securityService = securityService;
    }

    public void filter(ContainerRequestContext requestContext) {
        if (this.anonymous2LORequestVerifier.isValidOAuth1()) {
            log.debug("Escalating permissions to {} for anonymous 2LO REST call", this.permissions);
            this.securityService.withPermissions(this.permissions, String.format("Escalating permissions to %s for anonymous 2LO REST call", this.permissions)).applyToRequest();
        }
    }
}

