/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.filter;

import com.atlassian.bitbucket.dmz.auth.Anonymous2LORequestVerifier;
import com.atlassian.bitbucket.internal.rest.filter.OAuth1AnonymousAccessFilter;
import com.atlassian.bitbucket.internal.rest.filter.ResourceFilterProvider;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.rest.v2.api.annotation.EscalateAnonymous2LO;
import com.atlassian.bitbucket.user.SecurityService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.Provider;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;

@Provider
@Singleton
public class OAuth1AnonymousAccessFilterProvider
implements ResourceFilterProvider {
    private final Anonymous2LORequestVerifier anonymous2LORequestVerifier;
    private final SecurityService securityService;

    @Inject
    public OAuth1AnonymousAccessFilterProvider(Anonymous2LORequestVerifier anonymous2LORequestVerifier, SecurityService securityService) {
        this.anonymous2LORequestVerifier = anonymous2LORequestVerifier;
        this.securityService = securityService;
    }

    @Override
    public void registerFilter(ResourceInfo resourceInfo, FeatureContext context) {
        EscalateAnonymous2LO annotation = (EscalateAnonymous2LO)ObjectUtils.firstNonNull((Object[])new EscalateAnonymous2LO[]{resourceInfo.getResourceMethod().getAnnotation(EscalateAnonymous2LO.class), resourceInfo.getResourceClass().getAnnotation(EscalateAnonymous2LO.class)});
        if (annotation != null) {
            Set<Permission> permissions = Set.of(annotation.value());
            context.register((Object)new OAuth1AnonymousAccessFilter(this.anonymous2LORequestVerifier, permissions, this.securityService));
        }
    }
}

