/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.filter;

import com.atlassian.bitbucket.dmz.auth.Anonymous2LORequestVerifier;
import com.atlassian.bitbucket.dmz.auth.OAuth2Scope;
import com.atlassian.bitbucket.dmz.auth.ScopesRequestCacheDelegate;
import com.atlassian.bitbucket.internal.rest.util.OAuth2PermissionEscalator;
import com.atlassian.bitbucket.user.SecurityService;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import java.util.List;
import java.util.Set;

public class OAuth2AnonymousAccessFilter
implements ContainerRequestFilter {
    private final Anonymous2LORequestVerifier anonymous2LORequestVerifier;
    private final List<String> scopesAllowed;
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;
    private final SecurityService securityService;

    @Inject
    public OAuth2AnonymousAccessFilter(Anonymous2LORequestVerifier anonymous2LORequestVerifier, List<String> scopesAllowed, ScopesRequestCacheDelegate scopesRequestCacheDelegate, SecurityService securityService) {
        this.anonymous2LORequestVerifier = anonymous2LORequestVerifier;
        this.scopesAllowed = scopesAllowed;
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
        this.securityService = securityService;
    }

    public void filter(ContainerRequestContext requestContext) {
        Set oauth2Scopes;
        if (this.anonymous2LORequestVerifier.isValidOAuth2(this.scopesAllowed) && !(oauth2Scopes = OAuth2Scope.from((Set)this.scopesRequestCacheDelegate.getScopes())).isEmpty()) {
            OAuth2PermissionEscalator.forAnonymous(this.securityService).applyScopes(oauth2Scopes);
        }
    }
}

