/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.filter;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.auth.Anonymous2LORequestVerifier;
import com.atlassian.bitbucket.dmz.auth.ScopesRequestCacheDelegate;
import com.atlassian.bitbucket.internal.rest.filter.OAuth2AnonymousAccessFilter;
import com.atlassian.bitbucket.internal.rest.filter.ResourceFilterProvider;
import com.atlassian.bitbucket.user.SecurityService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.Provider;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

@Provider
@Singleton
public class OAuth2AnonymousAccessFilterProvider
implements ResourceFilterProvider {
    private final Anonymous2LORequestVerifier anonymous2LORequestVerifier;
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;
    private final SecurityService securityService;

    @Inject
    public OAuth2AnonymousAccessFilterProvider(Anonymous2LORequestVerifier anonymous2LORequestVerifier, ScopesRequestCacheDelegate scopesRequestCacheDelegate, SecurityService securityService) {
        this.anonymous2LORequestVerifier = anonymous2LORequestVerifier;
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
        this.securityService = securityService;
    }

    @Override
    public void registerFilter(ResourceInfo resourceInfo, FeatureContext context) {
        context.register((Object)new OAuth2AnonymousAccessFilter(this.anonymous2LORequestVerifier, List.of(this.getScopesAllowed(resourceInfo)), this.scopesRequestCacheDelegate, this.securityService));
    }

    private String[] getScopesAllowed(ResourceInfo resourceInfo) {
        ScopesAllowed scopesAllowedAnnotation = (ScopesAllowed)ObjectUtils.firstNonNull((Object[])new ScopesAllowed[]{resourceInfo.getResourceMethod().getAnnotation(ScopesAllowed.class), resourceInfo.getResourceClass().getAnnotation(ScopesAllowed.class)});
        if (scopesAllowedAnnotation != null) {
            return scopesAllowedAnnotation.requiredScope();
        }
        return new String[0];
    }
}

