/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.filter;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.auth.OAuth2Scope;
import com.atlassian.bitbucket.dmz.auth.ScopesRequestCacheDelegate;
import com.atlassian.bitbucket.internal.rest.util.OAuth2PermissionEscalator;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.ServiceUser;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import java.util.Set;

public class OAuth2ServiceAccountFilter
implements ContainerRequestFilter {
    private final AuthenticationContext authenticationContext;
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;
    private final SecurityService securityService;

    @Inject
    public OAuth2ServiceAccountFilter(AuthenticationContext authenticationContext, ScopesRequestCacheDelegate scopesRequestCacheDelegate, SecurityService securityService) {
        this.authenticationContext = authenticationContext;
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
        this.securityService = securityService;
    }

    public void filter(ContainerRequestContext requestContext) {
        ServiceUser serviceUser = this.getServiceUserForServiceAccount();
        if (serviceUser == null) {
            return;
        }
        Set oauth2Scopes = OAuth2Scope.from((Set)this.scopesRequestCacheDelegate.getScopes());
        if (!oauth2Scopes.isEmpty()) {
            OAuth2PermissionEscalator.forServiceUser(serviceUser, this.securityService).applyScopes(oauth2Scopes);
        }
    }

    private ServiceUser getServiceUserForServiceAccount() {
        boolean isAuthenticatedWithServiceAccount = this.authenticationContext.getProperties().containsKey("bbs.auth.service-account.id");
        if (!isAuthenticatedWithServiceAccount) {
            return null;
        }
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser instanceof ServiceUser) {
            return (ServiceUser)currentUser;
        }
        return null;
    }
}

