/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.filter;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.auth.ScopesRequestCacheDelegate;
import com.atlassian.bitbucket.internal.rest.filter.OAuth2ServiceAccountFilter;
import com.atlassian.bitbucket.internal.rest.filter.ResourceFilterProvider;
import com.atlassian.bitbucket.user.SecurityService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.Provider;

@Provider
@Singleton
public class OAuth2ServiceAccountFilterProvider
implements ResourceFilterProvider {
    private final AuthenticationContext authenticationContext;
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;
    private final SecurityService securityService;

    @Inject
    public OAuth2ServiceAccountFilterProvider(AuthenticationContext authenticationContext, ScopesRequestCacheDelegate scopesRequestCacheDelegate, SecurityService securityService) {
        this.authenticationContext = authenticationContext;
        this.securityService = securityService;
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
    }

    @Override
    public void registerFilter(ResourceInfo resourceInfo, FeatureContext context) {
        context.register((Object)new OAuth2ServiceAccountFilter(this.authenticationContext, this.scopesRequestCacheDelegate, this.securityService));
    }
}

