/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.filter;

import com.atlassian.bitbucket.dmz.rest.v2.util.StreamingResponse;
import com.atlassian.bitbucket.internal.rest.filter.ResourceFilterProvider;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.OutputStream;

public class StreamingResponseFilter
implements ContainerResponseFilter,
ResourceFilterProvider {
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Object entity = responseContext.getEntity();
        if (entity instanceof StreamingOutput) {
            responseContext.setEntity((Object)new ExceptionMappingStreamingOutput(responseContext, (StreamingOutput)entity));
        } else if (entity instanceof StreamingResponse) {
            responseContext.setEntity((Object)new ExceptionMappingStreamingResponse(responseContext, (StreamingResponse)entity));
        }
    }

    @Override
    public void registerFilter(ResourceInfo resourceInfo, FeatureContext context) {
        context.register((Object)this);
    }

    @VisibleForTesting
    static class ExceptionMappingStreamingOutput
    extends AbstractStreamingExceptionMapper
    implements StreamingOutput {
        private final StreamingOutput delegate;

        private ExceptionMappingStreamingOutput(ContainerResponseContext response, StreamingOutput delegate) {
            this.delegate = delegate;
        }

        public void write(OutputStream output) throws IOException, WebApplicationException {
            this.stream(() -> this.delegate.write(output));
        }
    }

    @VisibleForTesting
    static class ExceptionMappingStreamingResponse
    extends AbstractStreamingExceptionMapper
    implements StreamingResponse {
        private final StreamingResponse delegate;

        public ExceptionMappingStreamingResponse(ContainerResponseContext response, StreamingResponse delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(@Nonnull MultivaluedMap<String, Object> httpHeaders, @Nonnull OutputStream outputStream) throws IOException, WebApplicationException {
            this.stream(() -> this.delegate.write(httpHeaders, outputStream));
        }
    }

    @FunctionalInterface
    private static interface Streamable {
        public void stream() throws IOException, WebApplicationException;
    }

    private static abstract class AbstractStreamingExceptionMapper {
        private AbstractStreamingExceptionMapper() {
        }

        protected void stream(Streamable streamable) throws IOException, WebApplicationException {
            streamable.stream();
        }
    }
}

