/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.fragment;

import com.atlassian.bitbucket.internal.rest.fragment.RestFragmentModuleDescriptor;
import com.atlassian.bitbucket.rest.v2.fragment.RestFragment;
import com.atlassian.bitbucket.rest.v2.fragment.RestFragmentContext;
import com.atlassian.bitbucket.rest.v2.fragment.RestFragments;
import com.atlassian.bitbucket.rest.v2.fragment.RestFragmentsFactory;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class PluginRestFragmentsFactory
implements RestFragmentsFactory {
    private final PluginAccessor pluginAccessor;

    public PluginRestFragmentsFactory(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public boolean existsForKey(@Nonnull String restKey) {
        Objects.requireNonNull(restKey, "restKey");
        return this.getRestFragmentDescriptors().stream().map(RestFragmentModuleDescriptor::getLocation).anyMatch(restKey::equals);
    }

    @Override
    @Nonnull
    public RestFragments forKey(@Nonnull String restKey, @Nonnull Map<String, Object> requestContext) {
        Objects.requireNonNull(restKey, "restKey");
        Objects.requireNonNull(requestContext, "requestContext");
        Stream<RestFragmentModuleDescriptor> descriptors = this.getRestFragmentDescriptors().stream().filter(descriptor -> restKey.equals(descriptor.getLocation()));
        return new PluginRestFragments(requestContext, (Iterable)ModuleDescriptorUtils.toSortedModules(descriptors).collect(MoreCollectors.toImmutableList()));
    }

    private List<RestFragmentModuleDescriptor> getRestFragmentDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(RestFragmentModuleDescriptor.class);
    }

    private static class PluginRestFragments
    implements RestFragments {
        private final Map<String, Object> requestContext;
        private final Iterable<RestFragment> restFragments;

        private PluginRestFragments(Map<String, Object> requestContext, Iterable<RestFragment> restFragments) {
            this.requestContext = requestContext;
            this.restFragments = restFragments;
        }

        @Override
        @Nonnull
        public Map<String, Object> execute(@Nonnull RestFragmentContext fragmentContext) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            this.restFragments.forEach(fragment -> builder.putAll(fragment.execute(fragmentContext, this.requestContext)));
            return builder.build();
        }

        @Override
        @Nonnull
        public List<Object> validate(@Nonnull RestFragmentContext fragmentContext) {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.restFragments.forEach(fragment -> {
                Map<String, Object> error = fragment.validate(fragmentContext, this.requestContext);
                if (!error.isEmpty()) {
                    builder.add(error);
                }
            });
            return builder.build();
        }
    }
}

