/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.renderer;

import com.atlassian.bitbucket.internal.rest.renderer.DefaultSurrogateBuilder;
import com.atlassian.bitbucket.internal.rest.renderer.SurrogateBuilder;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class AggregateBuilder
implements SurrogateBuilder {
    private static final Logger log = LoggerFactory.getLogger(AggregateBuilder.class);
    protected final NavBuilder navBuilder;
    protected final Map<Class<?>, SurrogateBuilder> surrogates;

    public AggregateBuilder(NavBuilder navBuilder) {
        this.navBuilder = navBuilder;
        this.surrogates = Maps.newHashMap();
        this.addSurrogateBuilder(Collection.class, new CollectionSurrogateBuilder());
        this.addSurrogateBuilder(Map.class, new MapSurrogateBuilder());
        this.addSurrogateBuilder(Page.class, new PageSurrogateBuilder());
    }

    public void addSurrogateBuilder(Class<?> targetClass, SurrogateBuilder builder) {
        this.surrogates.put(targetClass, builder);
    }

    @Override
    public Object buildFor(Object object) {
        if (object == null) {
            return object;
        }
        Class<?> objectClass = object.getClass();
        if (objectClass.getPackage() == null) {
            return null;
        }
        if ("java.lang".equals(objectClass.getPackage().getName())) {
            return object;
        }
        List potentialSurrogates = this.surrogates.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isInstance(object)).collect(Collectors.toList());
        if (!potentialSurrogates.isEmpty()) {
            if (potentialSurrogates.size() > 1) {
                Collections.sort(potentialSurrogates, new Comparator<Map.Entry<Class<?>, SurrogateBuilder>>(this){

                    @Override
                    public int compare(Map.Entry<Class<?>, SurrogateBuilder> lhs, Map.Entry<Class<?>, SurrogateBuilder> rhs) {
                        return rhs.getKey().isAssignableFrom(lhs.getKey()) ? -1 : (lhs.getKey().isAssignableFrom(rhs.getKey()) ? 1 : 0);
                    }
                });
            }
            try {
                return ((SurrogateBuilder)((Map.Entry)potentialSurrogates.get(0)).getValue()).buildFor(object);
            }
            catch (Exception e) {
                log.error(String.format("Failed to create the JSON surrogate for an object of type %s", objectClass.getName()), (Throwable)e);
            }
        } else {
            log.trace("Unable to find a JSON surrogate for an object of type {}", (Object)objectClass.getName());
        }
        return object;
    }

    public void registerSurrogate(@Nonnull Class<?> surrogateClass) {
        JsonSurrogate surrogateInfo = surrogateClass.getAnnotation(JsonSurrogate.class);
        if (surrogateInfo == null) {
            throw new IllegalArgumentException(String.format("Cannot add %s as a surrogate - it is not annotated with %s", surrogateClass.getName(), JsonSurrogate.class.getName()));
        }
        SurrogateBuilder surrogateBuilder = this.createSurrogate(surrogateClass, surrogateInfo.value());
        if (surrogateBuilder == null) {
            throw new IllegalArgumentException(String.format("Cannot add %s as a surrogate - it does not have an appropriate constructor", surrogateClass.getName()));
        }
        this.addSurrogateBuilder(surrogateInfo.value(), surrogateBuilder);
    }

    protected SurrogateBuilder createSurrogate(Class<?> surrogateClass, Class<?> targetClass) {
        Constructor ctor = ClassUtils.getConstructorIfAvailable(surrogateClass, (Class[])new Class[]{targetClass, NavBuilder.class});
        if (ctor != null) {
            return new DefaultSurrogateBuilder(ctor, this.navBuilder);
        }
        ctor = ClassUtils.getConstructorIfAvailable(surrogateClass, (Class[])new Class[]{targetClass});
        if (ctor != null) {
            return new DefaultSurrogateBuilder(ctor, new Object[0]);
        }
        return null;
    }

    public class CollectionSurrogateBuilder
    implements SurrogateBuilder {
        @Override
        public Object buildFor(Object object) {
            return ((Collection)object).stream().map(AggregateBuilder.this::buildFor).collect(Collectors.toList());
        }
    }

    public class MapSurrogateBuilder
    implements SurrogateBuilder {
        @Override
        public Object buildFor(Object object) {
            return new LinkedHashMap(Maps.transformValues((Map)((Map)object), AggregateBuilder.this::buildFor));
        }
    }

    public class PageSurrogateBuilder
    implements SurrogateBuilder {
        @Override
        public Object buildFor(Object object) {
            return new RestPage<Object>((Page)object, AggregateBuilder.this::buildFor);
        }
    }
}

