/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.rest.renderer;

import com.atlassian.bitbucket.internal.rest.renderer.AggregateBuilder;
import com.atlassian.bitbucket.json.JsonRenderer;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarRequestHelper;
import com.atlassian.bitbucket.rest.v2.api.enrich.LinkEnricher;
import com.atlassian.bitbucket.rest.v2.api.enrich.MarkupEnricher;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSurrogateJsonRenderer
implements JsonRenderer {
    private static final Logger log = LoggerFactory.getLogger(BaseSurrogateJsonRenderer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected final AggregateBuilder aggregateBuilder;
    protected final AvatarEnricher avatarEnricher;
    protected final LinkEnricher linkEnricher;
    protected final MarkupEnricher markupEnricher;
    protected final RequestManager requestManager;

    public BaseSurrogateJsonRenderer(RequestManager requestManager, AggregateBuilder aggregateBuilder, AvatarEnricher avatarEnricher, MarkupEnricher markupEnricher, LinkEnricher linkEnricher) {
        this.requestManager = requestManager;
        this.aggregateBuilder = aggregateBuilder;
        this.avatarEnricher = avatarEnricher;
        this.markupEnricher = markupEnricher;
        this.linkEnricher = linkEnricher;
    }

    @Nullable
    public String render(@Nullable Object object, @Nonnull Map<String, Object> options) {
        Object surrogate = this.aggregateBuilder.buildFor(object);
        if (surrogate == null) {
            return null;
        }
        this.enrich(options, surrogate);
        try {
            return this.render(options, surrogate);
        }
        catch (IOException e) {
            log.error(String.format("Failed to render JSON for object of type %s with surrogate of type %s", object.getClass().getName(), surrogate.getClass().getName()), (Throwable)e);
            return null;
        }
    }

    private static Boolean doEndTagEscaping(Map<String, Object> options) {
        return BaseSurrogateJsonRenderer.isOptionEnabled(options, "noEndTagEscape");
    }

    private static boolean doHtmlCommentEscaping(Map<String, Object> options) {
        return BaseSurrogateJsonRenderer.isOptionEnabled(options, "noHtmlCommentEscape");
    }

    private static Boolean isOptionEnabled(Map<String, Object> options, String option) {
        Object noEscape = options.get(option);
        return noEscape instanceof Boolean ? !((Boolean)noEscape).booleanValue() : !(noEscape instanceof String) || Boolean.valueOf((String)noEscape) == false;
    }

    private void enrich(Map<String, Object> options, Object surrogate) {
        this.linkEnricher.enrich(surrogate);
        this.avatarEnricher.enrich(surrogate, AvatarRequestHelper.makeAvatarRequest(this.requestManager, options));
        if (options.containsKey("markup")) {
            this.markupEnricher.enrich(surrogate);
        }
    }

    @Nullable
    private String render(@Nonnull Map<String, Object> options, @Nonnull Object surrogate) throws IOException {
        String output = OBJECT_MAPPER.writeValueAsString(surrogate);
        if (BaseSurrogateJsonRenderer.doEndTagEscaping(options).booleanValue()) {
            output = output.replace("</", "<\\/");
        }
        if (BaseSurrogateJsonRenderer.doHtmlCommentEscaping(options)) {
            output = output.replace("<!--", "\\u003C!--");
        }
        return output;
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
    }
}

